﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using MicroRWD.Common;
using MicroRWD.QT;

namespace MicroRWD.UI.QT
{
    public partial class StatusPanel : UserControl
    {
        #region Constructor

        // Constructs a new status panel user control
        public StatusPanel()
        {
            InitializeComponent();
        }

        #endregion


        #region Private Methods

        // Handler for status changed events
        private void MyStatusChangedEventHandler(object sender, StatusUpdateEventArgs args)
        {
            // Update the UI object states
            this.UIThread(() => binaryStatusLabel.Text = args.Status.ToString());
            this.UIThread(() => hexStatusLabel.Text = args.Status.GetValue().ToString("X2"));
            this.UIThread(() => htrcAntennaFaultErrorCheckBox.Checked = args.Status.HTRC_AntennaFaultError);
            this.UIThread(() => relayEnabledCheckBox.Checked = args.Status.RelayEnabled);
            this.UIThread(() => rs232ErrorCheckBox.Checked = args.Status.RS232_Error);
            this.UIThread(() => rxOK_CheckBox.Checked = args.Status.RxOK);
            this.UIThread(() => tagOK_CheckBox.Checked = args.Status.TagOK);
            this.UIThread(() => eepromErrorCheckBox.Checked = args.Status.EEPROM_Error);
        }

        #endregion


        #region Event Handlers

        private void continuousPollCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            // Update continuous poll for associated reader
            Program.Controller.Reader.ContinuousPoll = continuousPollCheckBox.Checked;
            this.UIThread(() => pollNowButton.Enabled = !continuousPollCheckBox.Checked);
        }

        private void pollNowButton_Click(object sender, EventArgs e)
        {
            // Force manual poll for associated reader
            Program.Controller.Reader.CmdTagStatus();
        }

        private void StatusPanel_Load(object sender, EventArgs e)
        {
            // Register for status update events unless in design mode
            if (!DesignMode && (Program.Controller != null))
            {
                Program.Controller.Reader.StatusUpdateEvent += MyStatusChangedEventHandler;
            }
        }

        private void StatusPanel_VisibleChanged(object sender, EventArgs e)
        {
            // Update the visual elements to match the controller's state unless in design mode
            if (!DesignMode && (Program.Controller != null))
            {
                if (this.Visible)
                {
                    continuousPollCheckBox.Checked = Program.Controller.Reader.ContinuousPoll;
                }
            }
        }

        #endregion
   } 
}
